//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "ISO15693Command.h"

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface RFCommands: NSObject


/*---------------------- GENERAL COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_readTagConfig;
FOUNDATION_EXPORT NSString * const cmd_readTagConfigReg;
FOUNDATION_EXPORT NSString * const cmd_readTagStatus;
FOUNDATION_EXPORT NSString * const cmd_writeTagConfig;
FOUNDATION_EXPORT NSString * const cmd_writeTagConfigSession;
FOUNDATION_EXPORT NSString * const cmd_activateI2CSlave;
FOUNDATION_EXPORT NSString * const cmd_activateI2CMaster;
FOUNDATION_EXPORT NSString * const cmd_activateGPIOPWM;
FOUNDATION_EXPORT NSString * const cmd_readGPIOPWMConfig;
FOUNDATION_EXPORT NSString * const cmd_readI2cAddr;
FOUNDATION_EXPORT NSString * const cmd_readSRAM;

/*---------------------- GPIO COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_writeGPIOConfig;
FOUNDATION_EXPORT NSString * const cmd_writeGPIOSession;
FOUNDATION_EXPORT NSString * const cmd_gpioSetSessionOutput;
FOUNDATION_EXPORT NSString * const cmd_gpioClearSessionOutput;

/*---------------------- PWM COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_readPWM0Reg;
FOUNDATION_EXPORT NSString * const cmd_readPWM1Reg;
FOUNDATION_EXPORT NSString * const cmd_writePWMSession;
FOUNDATION_EXPORT NSString * const cmd_writePWM0Reg;
FOUNDATION_EXPORT NSString * const cmd_writePWM1Reg;

/*---------------------- PASSTHROUGH COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_writeSRAM;
#define RF_I2C 0
#define I2C_RF 1

/*---------------------- I2C MASTER COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_readI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetTempI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetXaccMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetYaccMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetZaccMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetXmagMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetYmagMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_GetZmagMSBI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_setHybridModeI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_setStandByModeI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_setControlReg2I2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_setActiveModeI2CMasterCommand;
FOUNDATION_EXPORT NSString * const cmd_i2cMasterConfigStatus;
FOUNDATION_EXPORT NSString * const cmd_readSRAMI2CMaster;

/*---------------------- ALM COMMANDS ----------------------*/

FOUNDATION_EXPORT NSString * const cmd_readALMConfiguration;

@end

NS_ASSUME_NONNULL_END
